<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


class CBlogWidgetCategories extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "1",
		"name"	=> "Category Menu",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $_LANG_ID , $base , $_SESS;

		if ($widget["settings"]["set_show"] && $widget["settings"]["set_labels"]) {
			$cond = " AND b.label_id IN (" . $widget["settings"]["set_labels"] . ")";
		}




		$labels = $this->db->QFetchRowArray(
			"SELECT 
				*
			FROM 
				{$this->tables['plugin:blog_labels']} as b ,
				{$this->tables['plugin:blog_labels_lang']} as l
			WHERE
				b.label_id=l.label_id AND 
				l.lang_id={$widget[lang_id]} AND 
				label_status = 1 AND 
				b.module_id = {$widget[widget_module]}
				{$cond}
		
			ORDER BY 
				label_parent ASC,
				label_order ASC
			"
		);

		if ($widget["settings"]["set_show"] == "1") {
			$labels = SortByKeys($labels , "label_id" , $widget["settings"]["set_labels"]);
		}


		if ($widget["settings"]["set_elements"] == "1") {
			$all = array(
				"label_id"			=> "-1",
				"label_status"		=> "1",
				"label_all"			=> "1",
				"label_title"		=> $widget["mod_settings"]["lang_all_topics"],
				"label_items"		=> $this->db->RowCount(
					$this->tables["plugin:blog_topics"],
					"WHERE item_status=1 AND item_date <= " . time() . " AND module_id={$widget[widget_module]} "
				),
			);


			array_unshift($labels , $all);
		}
	
		if (is_array($labels)) {				

			foreach ($labels as $key => $val) {

				if (!is_array($val)) {
					unset($labels[$key]);
				} else {							
					$labels[$key]["link"] = $widget["link"] . ($val["label_all"] ? "" : $val["label_url"] . "/");

					if ($val["label_id"] && ($val["label_id"] > 0)) {				
						$labels[$key]["label_items"] = $this->db->RowCount(
								$this->tables["plugin:blog_topics"],
								"WHERE find_in_set( {$val[label_id]}, item_labels ) AND item_status=1 AND item_date <= " . time() . " AND module_id={$val[module_id]}"
						);

						if (!$labels[$key]["label_items"] && !$widget["settings"]["set_empty"]) {
							unset($labels[$key]);
						}
						
					}


				}


				if (is_array($labels[$key])) {
					$labels[$key]["class"] = ($_GET["module_id"] == $widget["widget_module"]) && ($_GET["label"] == $val["label_url"]) ? $this->tpl->blockReplace("Selected") : "";
				}
				

			}


			if (!count($labels)) {
				return "";
			}
			
			//build the tree
			foreach ($labels as $key => $val) {
				if ($val["label_parent"]) {
					$_labels[$val["label_parent"]]["sub"][] = $val;
				} else {
					$_labels[$val["label_id"]] = $val;
				}				
			}
			
			$labels = $_labels;


			foreach ($labels as $key => $val) {

				if ($val["sub"]) {
					$labels[$key]["sub"] = $base->html->table(
						$this->tpl , 
						"" , 
						$val["sub"],
						array(
							"sub"	=> "",
						)
					);

					$labels[$key]["class"] .= $this->tpl->blockReplace("Sub");
				} else {
					$labels[$key]["sub"] = "";
				}				
			}


			



			return $this->tpl->blockreplace(
				"Main" , 
				array(
					"labels"	=> $base->html->Table(
						$this->tpl , 
						"", 
						$labels
					),

					"widget_title"	=> $widget["widget_name"],
				),

				$widget["mod_settings"]
			);

		}

	}
	
	

}


?>